//Source file: H:\middleware\src\Alkindi\BusinessServices\Util\Instrumenter.java

package Alkindi.Services.Util;

/* 
$Header: Instrumenter.java, 7, 2/12/01 4:47:44 PM, Schwartz, Joe$
$Log: 
 7    Alkindi Development1.6         2/12/01 4:47:44 PM   Schwartz, Joe  
      Changed to account for Product ID becoming an int.
 6    Alkindi Development1.5         1/26/01 5:48:29 PM   Schwartz, Joe  
      Improving efficiency.
 5    Alkindi Development1.4         1/4/01 2:11:16 PM    Schwartz, Joe  
      Changed to use external LogManager passed to new Constructor.
 4    Alkindi Development1.3         12/28/00 1:07:25 PM  Schwartz, Joe   Added
      Version Control header info.
 3    Alkindi Development1.2         12/26/00 6:57:13 PM  Schwartz, Joe   
 2    Alkindi Development1.1         12/26/00 5:36:58 PM  Schwartz, Joe   
 1    Alkindi Development1.0         12/21/00 2:24:59 PM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Utility class used for code instrumentation. Provides timing.
 */
public class Instrumenter implements Cloneable 
{
	private static final Instrumenter instrInstance = new Instrumenter();
	private LogManager logger = null;
	private long startTime = 0;
	private long stopTime = 0;
	private static String clName;
	private String meName;
	
	private Instrumenter() 
	{
	}
	
	/**
	 * Factory method to retrieve an instance of this class.
	 * @param logMgr A Log Manager instance to use.
	 * @param clName The name of the class to use in logging.
	 * @param meName The method name to use in logging.
	 * @return Instrumenter
	 * @roseuid 3A7F0170001F
	 */
	public static Alkindi.Services.Util.Instrumenter getInstance(final Alkindi.Services.Util.LogManager logMgr, final java.lang.String clNameIn, final java.lang.String meNameIn) 
	{
		try {
			Instrumenter instr = (Instrumenter)instrInstance.clone();
			instr.logger = logMgr;
			instr.clName = clNameIn;
			instr.meName = meNameIn;
			return instr;
		}
		catch (CloneNotSupportedException cne) {
			return null;
		}
	}
	
	/**
	 * @roseuid 3A421F5703D8
	 */
	public final void startTiming() 
	{
		startTime = System.currentTimeMillis();
	}
	
	/**
	 * Stops timing and logs the result using the given Class and Method names.
	 * @return long the time in ms since startTime was called
	 * @roseuid 3A421F6B033C
	 */
	public final long stopTiming() 
	{
		stopTime = System.currentTimeMillis();
		logger.log(clName, meName, "Operation took " + (stopTime-startTime) + " ms");
		return stopTime-startTime;
	}
	
	/**
	 * Stops timing and logs the result and the given message using the given Class and Method names.
	 * @param msg an additional message to log
	 * @return long the time in ms since startTime was called
	 * @roseuid 3A421FFD003E
	 */
	public final long stopTiming(final java.lang.String msg) 
	{
		stopTime = System.currentTimeMillis();
		logger.log(clName, meName, msg + ": " + (stopTime-startTime) + " ms");
		return stopTime-startTime;
	}
	
	/**
	 * Returns the time since startTime() was called in milliseconds.
	 * @return long
	 * @roseuid 3A42208C01B5
	 */
	public final long timeSpent() 
	{
		return stopTime-startTime;
	}
}
